/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.dialog.comp.MessageDisplay;
import DE.siemens.ad.logo.dialog.comp.MessageReceiptListener;
import DE.siemens.ad.logo.dialog.comp.display.DefaultDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.DisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.IONameDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.MessageParameterDisplayModelPlain;
import DE.siemens.ad.logo.dialog.comp.display.MessageParameterDisplayModelRTF;
import DE.siemens.ad.logo.dialog.comp.display.RectangleElementsDisplayModel;
import DE.siemens.ad.logo.dialog.comp.display.SpecialCharacterDisplayElement;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.HardwareChangedEvent;
import DE.siemens.ad.logo.model.Interpreter;
import DE.siemens.ad.logo.model.MessageManager;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.model.ParameterItemList;
import DE.siemens.ad.logo.model.ParameterItemTable;
import DE.siemens.ad.logo.model.ProtectionParameter;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Logger.ErrorInfo;
import DE.siemens.ad.logo.util.MessageGlobalInfo;
import DE.siemens.ad.logo.util.MessageLine;
import DE.siemens.ad.logo.util.MessageLineRTF;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.datatransfer.StringSelection;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Time;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public class MessageParameter
extends ProtectionParameter
implements MessageReceiptListener {
    private static transient Hashtable fSpecialCharactersTable;
    static final long serialVersionUID = 1L;
    private int serializedDataVersion = 2;
    private Integer fPriority = null;
    private boolean fReceipt = false;
    private boolean fReceiptDone = true;
    private MessageLine[] fMessage;
    private MessageText[] fMessageRTFs;
    private int fDefaultCharSetID = 0;
    private boolean fShowDetailInParamText;
    private static final int MAX_CHARSET_COUNT = 2;
    protected transient int[] fSelectedCharSets = new int[2];
    private int fMsgNumber = -1;
    private transient boolean fOldInput1 = false;
    private transient long fEnableTime = 0L;
    private transient long fLastUpdateTime;
    private transient boolean fLastValue;

    private String replaceSpecialCharacters(String s) {
        Hashtable specialCharacters = MessageParameter.getSpecialCharactersTable();
        StringBuffer returnString = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char currentCharacter = s.charAt(i);
            if (!specialCharacters.containsKey(new Integer(currentCharacter))) {
                returnString.append(currentCharacter);
                continue;
            }
            String displayedString = (String)specialCharacters.get(new Integer(currentCharacter));
            if (displayedString == null) {
                returnString.append("!!!unknown special character!!!");
                continue;
            }
            returnString.append(displayedString);
        }
        return returnString.toString();
    }

    public MessageText getMessageRTF(int index) {
        if (index < 0 || index >= 2) {
            return null;
        }
        return this.getMessageRTFs()[index];
    }

    public MessageText[] getMessageRTFs() {
        if (this.fMessageRTFs == null) {
            this.fMessageRTFs = new MessageText[2];
        }
        return this.fMessageRTFs;
    }

    public MessageText getMessageText_1() {
        return this.getMessageRTF(0);
    }

    public MessageText getMessageText_2() {
        return this.getMessageRTF(1);
    }

    public int getCurrentTextID() {
        if (this.getMessageRTFs()[this.fDefaultCharSetID] == null) {
            this.fDefaultCharSetID = 1 - this.fDefaultCharSetID;
        }
        return this.fDefaultCharSetID;
    }

    public void setCurrentTextID(int index) {
        this.fDefaultCharSetID = index % 2;
    }

    public MessageParameter() {
    }

    public MessageParameter(Block block) {
        super(block);
        this.fParameter = 1;
        if (this.getBlock().getWiringDiagram() != null && this.getBlock().getWiringDiagram().getMessageManager().isRTFMessage()) {
            this.fDefaultCharSetID = this.getMessageGlobalInfo().getCurCharSetID();
            this.getMessageRTFs()[this.fDefaultCharSetID] = new MessageText(0, this.getMessageGlobalInfo().getSelectedCharSet(this.fDefaultCharSetID), this);
        }
    }

    public boolean isRTF() {
        boolean ret = false;
        for (int i = 0; i < this.getMessageRTFs().length; ++i) {
            if (this.getMessageRTFs()[i] == null) continue;
            ret = true;
            break;
        }
        return ret;
    }

    private boolean enableTextRTF(int charSetID, int newCharSet) {
        int textID = this.getMessageManager().getFreeMessageTextID();
        if (textID == -1 || this.getMessageRTFs()[charSetID] != null) {
            return false;
        }
        this.getMessageRTFs()[charSetID] = new MessageText(textID, newCharSet, this);
        this.fDefaultCharSetID = charSetID;
        return true;
    }

    public boolean disableTextRTF(int charSetID) {
        if (this.getMessageRTFs()[charSetID] == null || this.getMessageRTFs()[1 - charSetID] == null) {
            System.out.println("Delete message failed!");
            return false;
        }
        this.getMessageRTFs()[charSetID] = null;
        this.fDefaultCharSetID = 1 - charSetID;
        return true;
    }

    private MessageManager getMessageManager() {
        return this.getBlock().getWiringDiagram().getMessageManager();
    }

    private MessageGlobalInfo getMessageGlobalInfo() {
        return this.getBlock().getWiringDiagram().getMessageGlobalInfo();
    }

    protected boolean calculateValue(boolean input1) {
        long currentTime;
        boolean result;
        if (input1) {
            result = true;
            if (!this.fLastValue) {
                this.fEnableTime = this.fInterpreter.getCurrentSimulationClockTime();
            }
            this.setReceiptDone(true);
        } else {
            if (this.fOldInput1) {
                this.setReceiptDone(false);
            }
            result = !this.isReceiptDone();
        }
        if (this.fOldInput1 != input1) {
            this.getParameterUpdateEvent().setBinaryValue("I0", input1);
            this.fOldInput1 = input1;
            this.fCurrentParameterText = this.calculateCurrentParameterText();
            this.fireParameterUpdateEvent();
        }
        if ((currentTime = this.fInterpreter.getCurrentSimulationClockTime()) - this.fLastUpdateTime > 1000L) {
            this.fLastUpdateTime = currentTime;
            this.fCurrentParameterText = this.calculateCurrentParameterText();
        }
        this.fLastValue = result;
        return result;
    }

    public boolean getEnableInput() {
        return this.fOldInput1;
    }

    public MessageLine[] getMessage() {
        if (this.fMessage == null) {
            this.fMessage = new MessageLine[this.getNrOfMessageLines()];
            for (int i = 0; i < this.getNrOfMessageLines(); ++i) {
                this.fMessage[i] = new MessageLine(i);
            }
        }
        return this.fMessage;
    }

    public int getMsgNumber() {
        return this.fMsgNumber;
    }

    protected int getNrOfMessageLines() {
        return 4;
    }

    public String getParameterText() {
        StringBuffer result = new StringBuffer(46);
        StringBuffer crlf = new StringBuffer("\n");
        result.append("Prio = ").append(this.getPriority().toString()).append("\n");
        result.append(this.isReceipt() ? "Quit = on" : "Quit = off");
        if (this.isRTF()) {
            for (int i = 0; i < this.getMessageRTFs().length; ++i) {
                result.append(crlf);
                result.append("Text" + (i + 1) + ": ");
                if (this.getMessageRTFs()[i] != null) {
                    if (this.fShowDetailInParamText) {
                        result.append(this.getMessageRTFs()[i].getInfoAsString());
                        continue;
                    }
                    result.append("enabled");
                    continue;
                }
                result.append("disabled");
            }
        } else {
            for (int i = 0; i < this.getMessage().length; ++i) {
                String s = this.getMessage()[i].getParameterText();
                if (s.trim().length() == 0) {
                    crlf.append("\n");
                    continue;
                }
                result.append(crlf);
                crlf.setLength(0);
                crlf.append("\n");
                result.append(this.replaceSpecialCharacters(s));
            }
        }
        return result.toString();
    }

    public Integer getPriority() {
        if (this.fPriority == null) {
            this.fPriority = this.getMessageManager().getFreePriority();
        }
        return this.fPriority;
    }

    public boolean getValue(boolean input1) {
        boolean result = this.calculateValue(input1);
        this.getParameterUpdateEvent().setBinaryValue(result);
        if (this.fLastBinaryValue != result) {
            this.fCurrentParameterText = this.calculateCurrentParameterText();
            this.fireParameterUpdateEvent();
            this.fLastBinaryValue = result;
        }
        return result;
    }

    public void init(Interpreter interpreter, boolean forceReset) {
        super.init(interpreter, forceReset);
        this.fOldInput1 = false;
        this.setReceiptDone(true);
        this.getParameterUpdateEvent().setBinaryValue("I0", false);
        this.fCurrentParameterText = this.calculateCurrentParameterText();
        this.fireParameterUpdateEvent();
    }

    public boolean isReceipt() {
        return this.fReceipt;
    }

    public boolean isReceiptDone() {
        return this.isReceipt() ? this.fReceiptDone : true;
    }

    public void messageReceipt(MessageDisplay messageDisplay) {
        this.setReceiptDone(true);
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fPriority = new Integer(dr.readInt());
        this.setReceipt(dr.readBoolean());
        this.fMsgNumber = dr.readInt();
        this.fSelectedCharSets[0] = dr.readInt();
        this.fSelectedCharSets[1] = dr.readInt();
        if (dr.readBoolean()) {
            this.setParameterTextMode(dr.readBoolean());
            MessageLineRTF[] messageLineRTF = null;
            for (int i = 0; i < this.getMessageRTFs().length; ++i) {
                if (!dr.readBoolean()) continue;
                this.getMessageRTFs()[i] = new MessageText(i, this.fSelectedCharSets[i], this);
                this.getMessageRTFs()[i].setTickerType(dr.readInt());
                this.getMessageRTFs()[i].setShowDest(dr.readInt());
                messageLineRTF = this.getMessageRTFs()[i].getMessageLineRTF();
                StringBuffer contents = new StringBuffer();
                String temp = null;
                for (int j = 0; j < this.getNrOfMessageLines(); ++j) {
                    messageLineRTF[i].setTickerLine(dr.readBoolean());
                    temp = dr.readString();
                    if (temp == null || temp.length() == 0) {
                        temp = " ";
                    }
                    contents.append(temp).append("\n");
                }
                contents.deleteCharAt(contents.length() - 1);
                MessageParameterDisplayModelRTF model = new MessageParameterDisplayModelRTF(this, i);
                model.paste(new StringSelection(contents.toString()), new Point(0, 0));
                MessageManager.fillMessageLineRTFsFromDisplayModel(this.getMessageRTFs()[i], model);
            }
        } else {
            this.fMessage = new MessageLine[this.getNrOfMessageLines()];
            for (int i = 0; i < this.getNrOfMessageLines(); ++i) {
                this.fMessage[i] = new MessageLine(i);
                this.fMessage[i].setText(dr.readString());
            }
        }
    }

    public void setMessage(MessageLine[] newMessage) {
        if (newMessage != this.fMessage) {
            this.messageLinesCleared();
            this.fMessage = newMessage;
        }
    }

    public void setMessageRTF(MessageText newMessageText, int charSetID) {
        this.getMessageRTFs()[charSetID] = newMessageText;
    }

    public void setMsgNumber(int newMsgNumber) {
        this.fMsgNumber = newMsgNumber;
    }

    private boolean areMessageTextAndParametersMixed() {
        MessageLine[] messageLines = this.getMessage();
        for (int i = 0; i < messageLines.length; ++i) {
            ParameterItem parameterItem = messageLines[i].getParameterItem();
            if (parameterItem == null || messageLines[i].getLength() <= parameterItem.getWidth()) continue;
            return true;
        }
        return false;
    }

    private boolean areParameterItemsAvailable(Hardware newHardware) {
        MessageLine[] messageLines = this.getMessage();
        ParameterItemTable newParameterItemTable = null;
        try {
            newParameterItemTable = (ParameterItemTable)newHardware.getProperty("parameterItemTable");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        if (newParameterItemTable == null) {
            return false;
        }
        for (int i = 0; i < messageLines.length; ++i) {
            Block block;
            BlockParameter substitutedBlockParameter;
            String parameterItemIDinNewHardware;
            ParameterItem parameterItem = messageLines[i].getParameterItem();
            if (parameterItem != null) {
                BlockParameter originalBlockParameter = messageLines[i].getBlockParameter();
                Block block2 = newHardware.getSubstitutionBlock(originalBlockParameter.getBlock());
                BlockParameter substitutedBlockParameter2 = block2.getParameter();
                ParameterItemList parameterItemList = newParameterItemTable.getParameterItems(substitutedBlockParameter2);
                if (parameterItemList.getParameterItem(parameterItemIDinNewHardware = newParameterItemTable.getSubstituteParameterItem(parameterItem.getIdentifier(), originalBlockParameter, substitutedBlockParameter2)) != null) continue;
                return false;
            }
            BlockParameter blockParameter = messageLines[i].getBlockParameter();
            String parameterItemIdentifier = messageLines[i].getParameterItemIdentifier();
            if (blockParameter == null || parameterItemIdentifier == null || !(parameterItemIDinNewHardware = newParameterItemTable.getSubstituteParameterItem(parameterItemIdentifier, blockParameter, substitutedBlockParameter = (block = newHardware.getSubstitutionBlock(blockParameter.getBlock())).getParameter())).equals(parameterItemIdentifier)) continue;
            return false;
        }
        return true;
    }

    public void hardwareChangeFinished(HardwareChangedEvent hardwareChangedEvent) {
        int i;
        Hardware newHardware = (Hardware)hardwareChangedEvent.getNewValue();
        ParameterItemTable newParameterItemTable = (ParameterItemTable)newHardware.getProperty("parameterItemTable");
        MessageLine[] messageLines = this.getMessage();
        for (i = 0; i < messageLines.length; ++i) {
            BlockParameter blockParameter;
            String parameterItemIdentifier = messageLines[i].getParameterItemIdentifier();
            BlockParameter newBlockParameter = blockParameter = messageLines[i].getBlockParameter();
            if (blockParameter == null) continue;
            Block block = blockParameter.getBlock();
            if (hardwareChangedEvent.getSubstitutedBlocksDictionary().containsKey(block)) {
                Block newBlock = (Block)hardwareChangedEvent.getSubstitutedBlocksDictionary().get(block);
                newBlockParameter = newBlock.getParameter();
                messageLines[i].setBlockParameter(newBlockParameter);
            }
            if (parameterItemIdentifier != null && !parameterItemIdentifier.equals("")) {
                String parameterItemIDinNewHardware = newParameterItemTable.getSubstituteParameterItem(parameterItemIdentifier, blockParameter, newBlockParameter);
                if (parameterItemIdentifier.equals(parameterItemIDinNewHardware)) continue;
                messageLines[i].setParameterItemIdentifier(parameterItemIDinNewHardware);
                continue;
            }
            System.err.println(this + ": No parameterItemIdentifier set although blockReference is set!");
        }
        if (this.isRTF()) {
            for (i = 0; i < this.getMessageRTFs().length; ++i) {
                if (this.getMessageRTFs()[i] == null) continue;
                for (int j = 0; j < this.getNrOfMessageLines(); ++j) {
                    this.getMessageRTF(i).getMessageLineRTF()[j].hardwareChangeFinished(hardwareChangedEvent);
                }
            }
        }
    }

    public boolean isAvailable(Hardware hw, List errorList) {
        boolean available = true;
        if (!super.isAvailable(hw, errorList)) {
            available = false;
        }
        if (this.isRTF()) {
            if (!hw.supports("supportAsiaLanguage")) {
                errorList.add(new ErrorInfo(this, "error.convert.messageBlock.RTFNotSupported", hw));
                available = false;
            } else {
                for (int i = 0; i < 2; ++i) {
                    if (this.getMessageRTF(i) == null || this.fSelectedCharSets == null || this.fSelectedCharSets[i] != 129 || hw.supports("SupportJapaneseLanguage")) continue;
                    errorList.add(new ErrorInfo(this, "dialog.powerOnScreen.lscDonotSupportSJIS", hw));
                    available = false;
                    break;
                }
            }
        }
        if (this.containsSpecialCharacters() && !hw.supports("mixedMessageTextAndParameter")) {
            errorList.add(new ErrorInfo(this, "error.convert.messageBlock.specialCharactersNotSupported", hw));
            available = false;
        }
        if (this.areMessageTextAndParametersMixed() && !hw.supports("mixedMessageTextAndParameter")) {
            errorList.add(new ErrorInfo(this, "error.convert.messageBlock.parameterTextMixingNotSupported", hw));
            available = false;
        }
        if (this.isReceipt() && !hw.supports("messageBlockWithReceipt")) {
            errorList.add(new ErrorInfo(this, "error.convert.messageBlock.receiptNotSupported", hw));
            available = false;
        }
        if (!this.areParameterItemsAvailable(hw)) {
            errorList.add(new ErrorInfo(this, "error.convert.messageBlock.parameterItemNotAvailable", hw));
            available = false;
        }
        int maxWidth = hw.getIntProperty("displayWidth");
        if (this.getMinimumDisplayColumns() > maxWidth) {
            MessageLine[] messageLines = this.getMessage();
            StringBuffer wrongLines = new StringBuffer("[");
            for (int i = 0; i < messageLines.length; ++i) {
                if (messageLines[i].getLength() <= maxWidth) continue;
                wrongLines.append(i + 1).append(",");
            }
            wrongLines.deleteCharAt(wrongLines.length() - 1);
            if (wrongLines.length() == 2) {
                wrongLines.deleteCharAt(0);
            } else {
                wrongLines.append("]");
            }
            Object[] msgParam = new Object[]{wrongLines, new Integer(maxWidth)};
            if (wrongLines.length() == 1) {
                errorList.add(new ErrorInfo(this, "error.convert.messageBlock.oneLineTooSmall", msgParam, hw));
            } else if (wrongLines.length() < 6) {
                errorList.add(new ErrorInfo(this, "error.convert.messageBlock.linesToSmall", msgParam, hw));
            } else {
                msgParam = new Object[]{new Integer(maxWidth)};
                errorList.add(new ErrorInfo(this, "error.convert.messageBlock.displayToSmall", msgParam, hw));
            }
            available = false;
        }
        if (this.getPriority() > hw.getIntProperty("msgPrioCount") - 1) {
            errorList.add(new ErrorInfo(this, "error.convert.messageBlock.tooMuchPrio", hw));
            available = false;
        }
        return available;
    }

    private boolean containsSpecialCharacters() {
        if (this.fMessage == null) {
            return false;
        }
        for (int i = 0; i < this.fMessage.length; ++i) {
            String text = this.fMessage[i].getText();
            for (int j = 0; j < text.length(); ++j) {
                char currentCharacter = text.charAt(j);
                if (!MessageParameter.getSpecialCharactersTable().containsKey(new Integer(currentCharacter))) continue;
                return true;
            }
        }
        return false;
    }

    public static synchronized Hashtable getSpecialCharactersTable() {
        if (fSpecialCharactersTable == null) {
            fSpecialCharactersTable = new Hashtable();
            fSpecialCharactersTable.put(new Integer(143), Character.toString('\u2103'));
            fSpecialCharactersTable.put(new Integer(159), Character.toString('\u2109'));
            fSpecialCharactersTable.put(new Integer(204), "\u00b0");
            fSpecialCharactersTable.put(new Integer(128), Character.toString('\u25b2'));
            fSpecialCharactersTable.put(new Integer(129), Character.toString('\u25bc'));
            fSpecialCharactersTable.put(new Integer(130), Character.toString('\u25c4'));
            fSpecialCharactersTable.put(new Integer(131), Character.toString('\u25ba'));
            fSpecialCharactersTable.put(new Integer(186), Character.toString('\u00b1'));
            fSpecialCharactersTable.put(new Integer(136), "\u20ac");
        }
        return fSpecialCharactersTable;
    }

    private int getMinimumDisplayColumns() {
        MessageLine[] messageLines = this.getMessage();
        int maxColumn = -1;
        for (int i = 0; i < messageLines.length; ++i) {
            int currentLineLength = messageLines[i].getLength();
            maxColumn = Math.max(maxColumn, currentLineLength);
        }
        return maxColumn;
    }

    public void setPriority(Integer newPriority) {
        this.fPriority = newPriority;
    }

    public void setReceipt(boolean newReceipt) {
        this.fReceipt = newReceipt;
        if (newReceipt) {
            if (!this.fOldInput1) {
                this.setReceiptDone(true);
            } else {
                this.setReceiptDone(false);
            }
        } else if (this.fOldInput1) {
            this.setReceiptDone(false);
        } else {
            this.setReceiptDone(true);
        }
    }

    public void setReceiptDone(boolean newReceiptDone) {
        this.fReceiptDone = newReceiptDone;
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeInt(this.fPriority);
        dw.writeBoolean(this.isReceipt());
        dw.writeInt(this.fMsgNumber);
        if (this.fSelectedCharSets == null) {
            this.fSelectedCharSets = new int[2];
        }
        try {
            this.fSelectedCharSets[0] = this.getMessageGlobalInfo().getSelectedCharSet(0);
            this.fSelectedCharSets[1] = this.getMessageGlobalInfo().getSelectedCharSet(1);
        }
        catch (NullPointerException ne) {
            this.fSelectedCharSets[0] = 1;
            this.fSelectedCharSets[1] = 1;
        }
        dw.writeInt(this.fSelectedCharSets[0]);
        dw.writeInt(this.fSelectedCharSets[1]);
        dw.writeBoolean(this.isRTF());
        if (this.isRTF()) {
            dw.writeBoolean(this.getParameterTextMode());
            for (int i = 0; i < this.getMessageRTFs().length; ++i) {
                boolean textEnabled = this.getMessageRTFs()[i] != null;
                dw.writeBoolean(textEnabled);
                if (!textEnabled) continue;
                MessageText text = this.getMessageRTFs()[i];
                dw.writeInt(text.getTickerType());
                dw.writeInt(text.getShowDest());
                for (int j = 0; j < text.getMessageLineRTF().length; ++j) {
                    dw.writeBoolean(text.getMessageLineRTF()[j].isTickerLine());
                    dw.writeString(text.getMessageLineRTF()[j].getStringInfo(false));
                }
            }
        } else {
            for (int i = 0; i < this.getMessage().length; ++i) {
                dw.writeString(this.getMessage()[i].getStringInfo());
            }
        }
    }

    public Time getEnableTime() {
        return new Time(this.fEnableTime);
    }

    public void setEnableTime(Time newTime) {
        this.fEnableTime = newTime.getTime();
    }

    public Date getEnableDate() {
        return new Date(this.fEnableTime);
    }

    public void setEnableDate(Date newDate) {
        this.fEnableTime = newDate.getTime();
    }

    public Time getCurrentTime() {
        if (this.fInterpreter != null) {
            return new Time(this.fInterpreter.getCurrentSimulationClockTime());
        }
        return new Time(System.currentTimeMillis());
    }

    public void setCurrentTime(Time value) {
        throw new IllegalStateException("The method " + this.getClass().getName() + ".setCurrentTime(Time) is not supported");
    }

    public void setCurrentDate(Date value) {
        throw new IllegalStateException("The method " + this.getClass().getName() + ".setCurrentDate(Date) is not supported");
    }

    public Date getCurrentDate() {
        if (this.fInterpreter != null) {
            return new Date(this.fInterpreter.getCurrentSimulationClockTime());
        }
        return new Date(System.currentTimeMillis());
    }

    public boolean syncPlainToRTFStyle(int newCharSet) {
        this.getMessageRTFs()[0] = null;
        this.getMessageRTFs()[1] = null;
        if (this.enableTextRTF(0, newCharSet)) {
            MessageParameterDisplayModelPlain srcModel = new MessageParameterDisplayModelPlain(this);
            MessageParameterDisplayModelRTF destModel = new MessageParameterDisplayModelRTF(this, 0);
            this.transferInfo(srcModel, destModel);
            MessageManager.fillMessageLineRTFsFromDisplayModel(this.getMessageRTFs()[0], destModel);
            this.messageLinesCleared();
            return true;
        }
        return false;
    }

    private void messageLinesCleared() {
        if (this.fMessage != null) {
            for (int i = 0; i < this.fMessage.length; ++i) {
                this.fMessage[i].removeAsParameterListener();
            }
            this.fMessage = null;
        }
    }

    public boolean syncRTFToPlainStyle() {
        if (this.getMessageRTF(0) != null && this.getMessageRTF(1) != null) {
            this.disableTextRTF(1);
        }
        MessageParameterDisplayModelRTF srcModel = new MessageParameterDisplayModelRTF(this, this.fDefaultCharSetID);
        MessageParameterDisplayModelPlain destModel = new MessageParameterDisplayModelPlain(this);
        this.transferInfo(srcModel, destModel);
        MessageManager.fillMessageLinesFromDisplayModel(this, destModel);
        this.fMessageRTFs = null;
        return true;
    }

    public boolean transferContentsToCharset(int charSetID, int newCharSet) {
        MessageText text = new MessageText(this.getMessageRTF(charSetID).getTextID(), newCharSet, this);
        MessageParameterDisplayModelRTF srcModel = new MessageParameterDisplayModelRTF(this, charSetID);
        if (((RectangleElementsDisplayModel)srcModel).getCharSet() == newCharSet) {
            return true;
        }
        RectangleElementsDisplayModel destModel = new RectangleElementsDisplayModel(this.getDimensionRTF(newCharSet), newCharSet);
        this.transferInfo(srcModel, destModel);
        MessageManager.fillMessageLineRTFsFromDisplayModel(text, destModel);
        this.getMessageRTFs()[charSetID] = text;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void transferInfo(RectangleElementsDisplayModel srcModel, RectangleElementsDisplayModel destModel) {
        DisplayElement dispElement = null;
        Point destPoint = new Point();
        Point srcPoint = new Point();
        int y = 0;
        while (y < destModel.getDisplayDimension().height) {
            int srcXCoordinate = 0;
            int parameterCountInOneLine = 0;
            int x = 0;
            while (x < destModel.getDisplayDimension().width && srcXCoordinate < srcModel.getDisplayDimension().width) {
                block14: {
                    block15: {
                        char c;
                        block16: {
                            destPoint.setLocation(x, y);
                            srcPoint.setLocation(srcXCoordinate, y);
                            dispElement = srcModel.getElementAt(srcPoint);
                            if (dispElement == null) {
                                ++x;
                                ++srcXCoordinate;
                                continue;
                            }
                            srcXCoordinate += dispElement.getWidth();
                            if (!(dispElement instanceof DefaultDisplayElement)) break block15;
                            c = ((DefaultDisplayElement)dispElement).getUserObject().toString().charAt(0);
                            if (!(dispElement instanceof SpecialCharacterDisplayElement)) break block16;
                            ((SpecialCharacterDisplayElement)dispElement).setWidth(this.getSpecialCharWidth(destModel));
                            break block14;
                        }
                        if (!destModel.isCharacterSupported(c)) {
                            x += dispElement.getWidth();
                            continue;
                        }
                        if (srcModel.isBiWidthCharacterset() == destModel.isBiWidthCharacterset()) break block14;
                        if (!srcModel.isBiWidthCharacterset() && destModel.isBiWidthCharacterset()) {
                            if (MessageGlobalInfo.getCharsetEncoding(destModel.getCharSet(), c).length == 2) {
                                ((DefaultDisplayElement)dispElement).setWidth(2);
                            }
                            break block14;
                        } else {
                            ((DefaultDisplayElement)dispElement).setWidth(1);
                        }
                        break block14;
                    }
                    if (destModel instanceof MessageParameterDisplayModelPlain) {
                        if (dispElement instanceof ParameterItem) {
                            if (++parameterCountInOneLine > 1) {
                                x += dispElement.getWidth();
                                continue;
                            }
                            break block14;
                        } else {
                            x += dispElement.getWidth();
                            continue;
                        }
                    }
                    if (dispElement instanceof IONameDisplayElement) {
                        IONameDisplayElement element = (IONameDisplayElement)dispElement;
                        element.transferNameToCharset(destModel.getCharSet());
                        element.setCharSet(destModel.getCharSet());
                    }
                }
                if (x + dispElement.getWidth() > destModel.getDisplayDimension().width || y + dispElement.getHeight() > destModel.getDisplayDimension().height) {
                    x += dispElement.getWidth();
                    continue;
                }
                destModel.setElementAt(dispElement, destPoint);
                x += dispElement.getWidth();
            }
            ++y;
        }
        return;
    }

    private int getSpecialCharWidth(RectangleElementsDisplayModel model) {
        return model.isBiWidthCharacterset() ? 2 : 1;
    }

    private Dimension getDimensionRTF(int charSet) {
        return new Dimension(MessageGlobalInfo.isBiWidthCharSet(charSet) ? 32 : 24, this.getNrOfMessageLines());
    }

    public static int getSpecialCharacterCode(char ch) {
        String character = Character.toString(ch);
        Iterator specialCharsIterator = MessageParameter.getSpecialCharactersTable().keySet().iterator();
        while (specialCharsIterator.hasNext()) {
            int code = (Integer)specialCharsIterator.next();
            if (!MessageParameter.getSpecialCharactersTable().get(code).equals(character)) continue;
            return code;
        }
        return -1;
    }

    public boolean getParameterTextMode() {
        return this.fShowDetailInParamText;
    }

    public void setParameterTextMode(boolean printDetail) {
        this.fShowDetailInParamText = printDetail;
    }

    public static class MessageText
    implements Serializable {
        private static final long serialVersionUID = -6462193082274717830L;
        private int fTickerType = 0;
        private int fShowDest = 3;
        private int fTextID = -1;
        private MessageParameter fOwner;
        MessageLineRTF[] fMessageLineRTF;

        public MessageText(int textID, int charSet, MessageParameter owner) {
            this.fTextID = textID;
            this.fOwner = owner;
            this.fMessageLineRTF = new MessageLineRTF[this.fOwner.getNrOfMessageLines()];
            for (int i = 0; i < this.fMessageLineRTF.length; ++i) {
                this.fMessageLineRTF[i] = new MessageLineRTF(owner, i, charSet);
            }
        }

        public MessageText() {
        }

        public MessageText(MessageParameter owner) {
            this.fOwner = owner;
            this.fTextID = -1;
        }

        public void copyFrom(MessageText source, MessageParameter cloneParam) {
            this.fMessageLineRTF = new MessageLineRTF[4];
            this.setTickerType(source.getTickerType());
            this.setShowDest(source.getShowDest());
            this.fTextID = source.getTextID();
            this.fOwner = source.fOwner;
            MessageLineRTF[] srcLines = source.getMessageLineRTF();
            MessageLineRTF[] cloneLines = this.getMessageLineRTF();
            for (int i = 0; i < cloneLines.length; ++i) {
                cloneLines[i] = new MessageLineRTF(cloneParam);
                cloneLines[i].copyFrom(srcLines[i], false);
            }
        }

        public void clearMapInfo() {
            for (int i = 0; i < this.fMessageLineRTF.length; ++i) {
                this.fMessageLineRTF[i].clearMapInfo();
            }
        }

        public int getTickerType() {
            return this.fTickerType;
        }

        public void setTickerType(int tickerType) {
            this.fTickerType = tickerType % 2;
        }

        public int getShowDest() {
            return this.fShowDest;
        }

        public void setShowDest(int dest) {
            this.fShowDest = dest;
        }

        public int getTextID() {
            return this.fTextID;
        }

        public void setTextID(int textID) {
            this.fTextID = textID;
        }

        public MessageLineRTF[] getMessageLineRTF() {
            return this.fMessageLineRTF;
        }

        public String getInfoAsString() {
            StringBuffer ret = new StringBuffer();
            int charsetID = this == this.fOwner.fMessageRTFs[0] ? 0 : 1;
            ret.append(MessageGlobalInfo.getCharSetName(this.fOwner.getMessageGlobalInfo().getSelectedCharSet(charsetID)));
            ret.append("/").append(this.getDestinationString()).append("/").append(this.getTickerTypeString());
            for (int i = 0; i < this.fMessageLineRTF.length; ++i) {
                ret.append("\n");
                if (this.getMessageLineRTF()[i].isTickerLine()) {
                    ret.append("<");
                } else {
                    ret.append("=");
                }
                ret.append(this.fMessageLineRTF[i].getStringInfo(true));
            }
            return ret.toString();
        }

        public String getDestinationString() {
            String ret;
            switch (this.getShowDest()) {
                case 1: {
                    ret = Language.getString("dialog.parameter.message.showDest0", "display?");
                    break;
                }
                case 2: {
                    ret = Language.getString("dialog.parameter.message.showDest1", "TD?");
                    break;
                }
                default: {
                    ret = Language.getString("dialog.parameter.message.showDest2", "both?");
                }
            }
            return ret;
        }

        public String getTickerTypeString() {
            if (this.getTickerType() == 0) {
                return "CBC";
            }
            return "LBL";
        }
    }
}

